#!/usr/bin/python
from time import localtime, strftime
import calendar
import os

''' Settings '''
HOME = os.path.expanduser('~')
CAL_PATH =  HOME + "/Documents/Notes-zim/Calendar"

year = strftime("%Y", localtime())
month = strftime("%m", localtime())
today = int(strftime("%d", localtime()))
fday = calendar.weekday(int(year), int(month), 1)

dir = os.path.join(CAL_PATH, year + "/" + month)

# Calendar
print "${color white}Mo Tu We Th Fr Sa Su${color}"
print "   "*(fday-1) + "  ",
for day in range(1,calendar.monthrange(int(year), int(month))[1]+1):
    daystr = "%02d" % day
    if day is today:
        daystr = "${color 0090ff}" + daystr + "${color}"
    if os.path.exists(os.path.join(dir, str(day) + ".txt")):
        daystr = "${color aaaaaa}" + daystr + "${color}"
    print daystr,
    if ((fday+day) % 7) == 0:
        print ""

