#!/usr/bin/python
import gtk
import os
import time

''' Settings '''
HOME = os.path.expanduser('~')
PROG_PATH = HOME + "/.bin/zimcal"
CAL_PATH =  HOME + "/Documents/Notes-zim/Calendar"

class ZimCalendar:
	def on_window_destroy(self, widget, data=None):
		gtk.main_quit()

	def __init__(self):
		builder = gtk.Builder()
		builder.add_from_file(os.path.join(PROG_PATH, "zim-cal.ui")) 
		self.window = builder.get_object("window")
		self.expand = builder.get_object("expand_btn")
		self.edit = builder.get_object("edit_textview")
		self.date = builder.get_object("date_calendar")
		self.edit_buffer = self.edit.get_buffer()
		builder.connect_signals(self)

		# Enable RGBA
		screen = self.window.get_screen()
		colormap = screen.get_rgba_colormap()
		self.window.set_colormap(colormap)
		
		# Initialize text
		clipboard = gtk.Clipboard(selection="PRIMARY")
		if clipboard.wait_is_text_available():
			clipboard.request_text(lambda clipboard, text, data=None: self.edit_buffer.set_text(text))

	def on_expand_btn_toggled(self, widget, data=None):
		if self.edit.get_visible():
			self.edit.hide()
			self.date.grab_focus()
			self.window.resize(1,1)
		else:
			self.edit.show()
			self.edit.grab_focus()
	
	def on_date_clicked(self, widget, data=None):
		""" Get the date and add the event """
		year, month, day = widget.get_date()
		month += 1    # fix month offset
		
		content_start, content_end = self.edit_buffer.get_bounds()
		content = self.edit_buffer.get_text(content_start, content_end)
		
		cur_date = time.strftime("%Y-%m-%dT%H:%M:%S.000000")
		
		date_tuple = time.strptime("%d, %d, %d" % (year, month, day), "%Y, %m, %d")
		title = time.strftime("%A %d %B %Y", date_tuple)
		folder = "%s/%04d/%02d" % (CAL_PATH, year, month)
		if not os.path.isdir(folder):
			os.makedirs(folder)
		with open("%s/%02d.txt" % (folder, day), 'w') as file:
			print >> file, "Content-Type: text/x-zim-wiki"
			print >> file, "Wiki-Format: zim 0.4"
			print >> file, "Creation-Date: %s\n" % cur_date
			print >> file, "====== %s ======\n" % title
			print >> file, "%s" % content
		self.window.destroy()
		gtk.main_quit()

	def on_date_keypress(self, widget, event, data=None):
		if event.keyval == gtk.keysyms.Return:
			self.on_date_clicked(self.date)
		elif event.keyval == gtk.keysyms.Escape:
			self.window.destroy()
			gtk.main_quit()

if __name__ == "__main__":
	calendar = ZimCalendar()
	calendar.window.show()
	gtk.main()

