#----------------------------
# A Mumbles Plugin for Gmail
#   Copyright (c) 2007 dot_j <dot_j[at]mumbles-project[dot]org>
#   Lisenced under the GPL
#	Modified for gmail by Steven (Stebalien.com)
#----------------------------

# We'll extend the MumblesPlugin class to create our Evolution plugin
from MumblesPlugin import *

class GmailMumbles(MumblesPlugin):	

	# Give our plugin a name (using the same name we used in setup.py).
	plugin_name = "GmailMumbles"

	# Use the dbus interface we saw in dbus-notify
	dbus_interface = "org.gmail.DBus"

	# Use the dbus path we saw in dbus-notify
	dbus_path = "/org/gmail/DBus"

	# Configure our plugin icon
	icons = {'gmail' : 'evolution.png'}	

	# setup the __init__ function where we define	
	# the dbus signal(s), to which, we are connecting.	
	# Note this function takes 2 parameters (mumbles_notify and	
	# session_bus) that we will hand off to our	
	# MumblesPlugin parent class
	def __init__(self, mumbles_notify, session_bus):

		# Here, we tell our plugin to connect the dbus signal
		# 'Newmail' to our plugin class's 'NewMail' function
		self.signal_config = {
	  		"NewMail": self.NewMail
		}

		# and hand off our mumbles_notify and session_bus objects to our parent
		MumblesPlugin.__init__(self, mumbles_notify, session_bus)	

	# NewMail function	
	# This will get called when a NewMail signal is received on the DBus from Evolution	
	# Note the function takes 2 parameters (the two we saw in the dbus-monitor activity)	
	# [edit: newer versions of Evolution may have a 3rd parameter,	
	# the follwoing should work with or without this parameter]
	def NewMail(self, subject, author):

		# Get our icon using the key we used above when configuring our icons dictionary
		icon = self.get_icon('gmail')

		# Define what we want to send in our notification:
		# Send a simple title
		title = "Email: %s" % (subject)

		# Let's send our folder name as our notification message
		message = author

		# Make Notification Clickable
		self.add_click_handler(self.onClick)
		
		# If you want to try an advanced version of the plugin,
		# see if you can use the supplied mbox_path to get more information
		# about the message that just arrived! And be sure to let us know
		# about your efforts.
		  
		# Finally, using our mumbles_notification object, send the notification

		self.mumbles_notify.alert(self.plugin_name, title, message, icon)
	
	# Define click function
	def onClick(self, widget, event, plugin_name):
		if event.button == 3:
			self.mumbles_notify.close(widget.window)
		else:
			os.system("evolution -c mail &")
