#!/usr/bin/python
## check-gmail.py -- A command line util to check GMail -*- Python -*-

# ======================================================================
# Copyright (C) 2006 Baishampayan Ghose <b.ghose@ubuntu.com>
# Time-stamp: Mon Jul 31, 2006 20:45+0530
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
# ======================================================================

import urllib             # For BasicHTTPAuthentication
import feedparser         # For parsing the feed
from textwrap import wrap # For pretty printing assistance
import gobject
import dbus
import dbus.service
from dbus.mainloop.glib import DBusGMainLoop
import time

# OPTIONS
CHECK_INTERVAL = 120	# Interval between checks in seconds
USERNAME = "User"		# Gmail username
PASSWORD = "Password"	# Gmail password

_URL = "https://mail.google.com/gmail/feed/atom"
DBusGMainLoop(set_as_default=True)
readList = []

class myURLOpener(urllib.FancyURLopener):
    def prompt_user_passwd(self, host, realm):
        return USERNAME, PASSWORD

class Gmail(dbus.service.Object):
    def __init__(self, object_path):
        dbus.service.Object.__init__(self, dbus.SessionBus(), "/org/gmail/DBus")

    @dbus.service.signal(dbus_interface='org.gmail.DBus',
                         signature='ss')
    def NewMail(self, title, sender):
        pass

e = Gmail('/Gmail-Checker')
	
def getFeed():
	'''The method to do HTTPBasicAuthentication'''
	f = opener.open(_URL)
	return f.read()

def readmail(feed):
    '''Parse the Atom feed and print a summary'''
    atom = feedparser.parse(feed)
    for i in xrange(len(atom.entries)):
		if atom.entries[i].id in readList:
			pass
		else:
			readList.append(atom.entries[i].id)
			e.NewMail(atom.entries[i].title, atom.entries[i].author)

if __name__ == "__main__":
	opener = myURLOpener()
	while 1 == 1:
		readmail(getFeed()) # Let the feed be chewed by feedparser
		time.sleep(CHECK_INTERVAL)
