from kupfer.objects import Action, TextLeaf
from kupfer import utils
import gwibber.util

__kupfer_name__ = _("Gwibber")
__kupfer_actions__ = (
		"GwibberPost",
	)
__description__ = "Post with Gwibber"
__version__ = "0.1"
__author__ = "Steven Allen"


class GwibberPost (Action):
	def __init__(self):
		Action.__init__(self, _("Post with Gwibber"))

	def activate(self, leaf):
		text=leaf.object
		gwibber.util.getbus("Service").SendMessage(text)

	def item_types(self):
		yield TextLeaf
	def valid_for_item(self, leaf):
		text=leaf.object
		return len(text) <= 140
	def get_description(self):
		return _("Post a message with gwibber.")
	def get_icon_name(self):
		return "gwibber"

