from __future__ import absolute_import

__kupfer_name__ = _("Exaile")
__kupfer_sources__ = ("ExaileSource", )
__description__ = _("Control exaile media player.")
__version__ = ""
__author__ = "Steven Allen"

import dbus

from kupfer.objects import RunnableLeaf, Source
from kupfer.obj.apps import AppLeafContentMixin
from kupfer import utils, icons, pretty

import pynotify

class PlayPause (RunnableLeaf):
	def __init__(self):
		RunnableLeaf.__init__(self, name=_("Play/Pause"))
	def run(self):
		utils.spawn_async(("exaile", "-t"))
	def get_description(self):
		return _("Resume/Pause playback in Exaile")
	def get_icon_name(self):
		return "media-playback-start"
class Next (RunnableLeaf):
	def __init__(self):
		RunnableLeaf.__init__(self, name=_("Next"))
	def run(self):
		utils.spawn_async(("exaile", "--next"))
	def get_description(self):
		return _("Jump to next track in Exaile")
	def get_icon_name(self):
		return "media-skip-forward"

class Previous (RunnableLeaf):
	def __init__(self):
		RunnableLeaf.__init__(self, name=_("Previous"))
	def run(self):
		utils.spawn_async(("exaile", "--previous"))
	def get_description(self):
		return _("Jump to previous track in Exaile")
	def get_icon_name(self):
		return "media-skip-backward"
class ExaileSource (AppLeafContentMixin, Source):
	appleaf_content_id = 'exaile'
	def __init__(self):
		Source.__init__(self, _("Exaile"))
	def get_items(self):
		yield PlayPause()
		yield Next()
		yield Previous()
	def provides(self):
		yield RunnableLeaf
	def get_description(self):
		return __description__
	def get_icon_name(self):
		return "exaile"
