# -*- coding: UTF-8 -*-

__kupfer_name__ = _("Evolution")
__kupfer_sources__ = ("ContactsSource", )
__description__ = _("Evolution contacts")
__version__ = "2010-02-08"
__author__ = "Francesco Marella, Karol Będkowski, Ulrik Sverdrup"

from evolution import ebook
from kupfer.objects import RunnableLeaf
from kupfer import utils
from kupfer.obj.apps import AppLeafContentMixin
from kupfer.obj.grouping import ToplevelGroupingSource
from kupfer.obj.contacts import ContactLeaf, EmailContact, email_from_leaf


class ContactsSource(AppLeafContentMixin, ToplevelGroupingSource):
	appleaf_content_id = 'evolution'

	def __init__(self, name=_("Evolution Address Book")):
		super(ContactsSource, self).__init__(name, "Contacts")

	def get_items(self):
		ebook_ = ebook.open_addressbook("default")
		for contact in ebook_.get_all_contacts():
			name = contact.get_property("full-name")
			email = contact.get_property("email-1")
			if email:
				yield EmailContact(email, name)

	def should_sort_lexically(self):
		return True

	def get_description(self):
		return _("Evolution contacts")

	def get_icon_name(self):
		return "evolution"

	def provides(self):
		yield RunnableLeaf
		yield ContactLeaf
