#----------------------------
# A Mumbles Plugin for Banshee
#   Copyright (c) 2008 Steven
#   Lisenced under the GPL
#----------------------------

from MumblesPlugin import *
import dbus

class BansheeMumbles(MumblesPlugin):
	
	# Plugin Info	
	plugin_name = "BansheeMumbles"
	icons = {'banshee' : 'rhythmbox.png'}	
	
	# DBus
	dbus_name = "org.bansheeproject.Banshee"
	dbus_interface = "org.bansheeproject.Banshee.PlayerEngine"
	dbus_path = "/org/bansheeproject/Banshee/PlayerEngine"
	
	def __init__(self, mumbles_notify, session_bus):

		# Here, we tell our plugin to connect the dbus signal
		self.signal_config = {
	  		"StateChanged": self.StateChanged
		}

		# and hand off our mumbles_notify and session_bus objects to our parent
		MumblesPlugin.__init__(self, mumbles_notify, session_bus)	

	# Called when banshees state is changed
	def StateChanged(self, state):
		if (state == "playing") or (state == "paused"):
			metadata = {}
			info = ["track-number", "name", "artist"]
			
			banshee_shell_object = self.session_bus.get_object(self.dbus_name, self.dbus_path, False)
			shell = dbus.Interface(banshee_shell_object, self.dbus_interface)
			data = shell.GetCurrentTrack()
			for key in data:
				if key in info:
					metadata[key] = data[key]
			# Get Icon
			icon = self.get_icon('banshee')

			# Title
			title = "Banshee %s:" %(state)

			# Track-Number - Song Title (Artist)
			message = "%d - %s (%s)" %(metadata["track-number"],metadata["name"],metadata["artist"])

			# Make Notification Clickable
			self.add_click_handler(self.onClick)
			  
			# Send Notification
			self.mumbles_notify.alert(self.plugin_name, title, message, icon)
	
	# Define click function
	def onClick(self, widget, event, plugin_name):
		if event.button == 3:
			self.mumbles_notify.close(widget.window)
		else:
			shell = dbus.Interface(self.session_bus.get_object(self.dbus_name, "/org/bansheeproject/Banshee/ClientWindow", False), "org.bansheeproject.Banshee.ClientWindow")
			shell.Present()
			self.mumbles_notify.close(widget.window)
